#!/bin/bash

session="$1"
device=1
environment='path/to/env'
name='original'
data_path='./data'
dataset='CIFAR10'
model_type='resnet18'
num_epochs=182
num_trials=1

file_location=algs.original

tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window $name
tmux send-keys -t $session:$window "source activate $environment" C-m
tmux send-keys -t $session:$window "python -m $file_location --data_path=$data_path --dataset=$dataset --name=$name --num_epochs=$num_epochs --model_type=$model_type --num_trials=$num_trials --device=$device" C-m

tmux attach-session -t $session